/**********************************************************************************************
* Device      : AD18F08
* Author      : ADUC AE Team
* Version     : V0.0.1
* Date        : 2022.11.24
* Description : TIMER3作为PWM周期定时器，f = 500Hz，输出引脚为 PB2、PB1、PB4、PA3、PB6、PB7  配置死区时间为2.3us左右
***********************************************************************************************/
#include "AD18F08.h"
#include <stdio.h>
#include "common.h"
#include "usart.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_OFF         :  LVR使能位
* _LVT24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTEN_OFF        :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位

*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                    );


//==============================================================================================
// ----Function: 主程序
// --Parameters: None
// -----Returns: None
//---------Note:
//==============================================================================================
void main (void)
{
	GPIO_Init();     //所有IO初始化

	IPEN = 0;	   	//禁止低优先级，优先高优先级中断
	PEIE = 1;    	//
	GIE = 1;     	//全局GIEH

	Timer3_PWM();        //Timer3 3组6路互补pwm输出


	//Setup3:配置各PWM的占空比

	//设置PWM2初始占空比为12%
	//占空比填值=周期*百分比=2000*0.12
	T3_PWM2_Duty(240);

	//设置PWM3初始占空比为20%
	//占空比填值=周期*百分比=2000*0.2
	T3_PWM3_Duty(400);

	//设置PWM4初始占空比为50%
	//占空比填值 =周期*百分比=2000*0.50
	T3_PWM4_Duty(1000);

	while(1);

}

//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关中断
	if(TMR3IF  &&  TMR3IE)
	{
		TMR3IF = 0;
	    PB3 =~PB3;
	}
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//进入中断后系统自动关中断

}

